#!/bin/sh

ROOT=$1
test -d "$ROOT" || exit 1

eval "$(xprop -root -notype 8s "=1; RULES=\$0; MODEL=\$1; LAYOUT=\$2; VARIANT=\$3; OPTIONS=\$4" _XKB_RULES_NAMES)"

test -z "$_XKB_RULES_NAMES" && exit 1
test -z "$VARIANT" && COMMENT_VARIANT="#"
test -z "$OPTIONS" && COMMENT_OPTIONS="#"

cat << EOF > $ROOT/etc/X11/xorg.conf.d/00-configured-keymap.conf
# This file is generated by $0.
#
# If you want to override settings in this file, edit
# 10-keyboard.conf in the same directory.

Section "InputClass"
    Identifier      "Configured Keymap"
    MatchIsKeyboard "on"
    MatchTag        "use_configured_keymap"

    Option          "xkb_rules"     "$RULES"
    Option          "xkb_model"     "$MODEL"
    Option          "xkb_layout"    "$LAYOUT"
    ${COMMENT_VARIANT}Option          "xkb_variant"   "$VARIANT"
    ${COMMENT_OPTIONS}Option          "xkb_options"   "$OPTIONS"
EndSection
EOF
