#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Licensed under the GNU General Public License, version 3.
# See the file http://www.gnu.org/licenses/gpl.txt

from inary.actionsapi import shelltools
from inary.actionsapi import inarytools
from inary.actionsapi import autotools
from inary.actionsapi import get

def setup():
    shelltools.system("./autogen.sh")
    autotools.configure("--disable-static \
                         --enable-more-warnings=yes \
                         --with-udev-base-dir=/lib/udev \
                         --enable-gtk-doc \
                         --with-polkit=permissive")

def build():
    autotools.make()

def check():
    autotools.make("check")

def install():
    autotools.rawInstall("DESTDIR=%s" % get.installDIR())

    inarytools.dodoc("README", "COPYING")
