#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Licensed under the GNU General Public License, version 3.
# See the file http://www.gnu.org/licenses/gpl.txt

from inary.actionsapi import get
from inary.actionsapi import autotools
from inary.actionsapi import inarytools
from inary.actionsapi import shelltools

def setup():
    autotools.rawConfigure("--prefix=/usr \
                            --mandir=/usr/share/man \
                            --disable-debug \
                            --disable-static \
                            --disable-stripping \
                            --enable-avfilter \
                            --enable-avresample \
                            --enable-fontconfig \
                            --enable-gnutls \
                            --enable-gpl \
                            --enable-libass \
                            --enable-libbluray \
                            --enable-libfreetype \
                            --enable-libgsm \
                            --enable-libmodplug \
                            --enable-libmp3lame \
                            --enable-libopencore_amrnb \
                            --enable-libopencore_amrwb \
                            --enable-libopenjpeg \
                            --enable-libopus \
                            --enable-libpulse \
                            --enable-librtmp \
                            --enable-libspeex \
                            --enable-libtheora \
                            --enable-libv4l2 \
                            --enable-libvorbis \
                            --enable-libx264 \
                            --enable-libx265 \
                            --enable-libxvid \
                            --enable-pic \
                            --enable-postproc \
                            --enable-runtime-cpudetect \
                            --enable-shared \
                            --enable-swresample \
                            --enable-vdpau \
                            --enable-version3 \
                            --enable-libdc1394 \
                            --enable-libcelt \
                            --enable-frei0r \
                            --enable-libcdio \
                            --enable-nonfree")

def build():
    autotools.make()
    autotools.make('tools/qt-faststart')

def install():
    autotools.rawInstall("DESTDIR=%s install-man" % get.installDIR())
    inarytools.dobin("tools/qt-faststart")
    inarytools.dodoc("Changelog", "README.md", "LICENSE.md", "COPYING*")
