const { ipcMain } = require("electron");
const { spawn } = require("child_process");

const handler = () => {
  ipcMain.on("terminal", (_, data) => {
    if (process.platform === "win32") {
      spawn("cmd", ["/c", "start", "docker", "exec", "-it", data, "sh"]);
    } else {
      spawn("exo-open", [
        "--launch",
        "TerminalEmulator",
        "docker",
        "exec",
        "-it",
        data,
        "sh"
      ]);
    }
  });
  ipcMain.on("viewer", (_, data) => {
    spawn("remote-viewer", [
      `spice://localhost:${data}`,
      "-f",
      "-t",
      "Oyun Parkı"
    ]);
  });
};

module.exports = handler;
