import Vue from "vue";
import App from "./App.vue";
import router from "./router";
import axios from "axios";

import style from "./assets/scss/main.module.scss";
import i18n from "./i18n";
Vue.prototype.$style = style;

Vue.prototype.$http = axios;
Vue.prototype.$http.defaults.baseURL = "http://localhost:3000";
Vue.prototype.$protocol = process.env.VUE_APP_PROTOCOL;

import dayjs from "dayjs";
import relativeTime from "dayjs/plugin/relativeTime";
import "dayjs/locale/tr";
dayjs.extend(relativeTime);
dayjs.locale("tr");
Vue.prototype.$dayjs = dayjs;

import { library } from "@fortawesome/fontawesome-svg-core";
import {
  faCircle,
  faExternalLinkAlt,
  faPlay, faStop, faTerminal, faTrash, faUndo,
} from "@fortawesome/free-solid-svg-icons";
import { FontAwesomeIcon } from "@fortawesome/vue-fontawesome";

library.add(
  faPlay,
  faStop,
  faUndo,
  faTrash,
  faExternalLinkAlt,
  faTerminal,
  faCircle
);

Vue.component("icon", FontAwesomeIcon);

Vue.config.productionTip = false;

new Vue({
  router,
  i18n,
  render: h => h(App)
}).$mount("#app");
