const webpack = require("webpack");

module.exports = {
  configureWebpack: {
    plugins: [
      new webpack.optimize.LimitChunkCountPlugin({
        maxChunks: 6
      })
    ]
  },

  chainWebpack: config => {
    config.plugin("html").tap(args => {
      args[0].title = "Oyun Parkı";
      return args;
    });
  },

  css: {
    extract: false,
    requireModuleExtension: true,
    loaderOptions: {
      css: {
        importLoaders: 1,
        modules: {
          localIdentName: "[hash:base64:5]"
        }
      }
    }
  },

  productionSourceMap: false,

  pluginOptions: {
    i18n: {
      locale: "tr",
      fallbackLocale: "tr",
      localeDir: "locales",
      enableInSFC: false
    },
    electronBuilder: {
      preload: "src/preload.js",
      builderOptions: {
        linux: {
          target: ["deb"],
          desktop: {
            Name: "Oyun Parkı",
            MimeType: "x-scheme-handler/oyunparki"
          }
        },
        deb: {
          depends: ["ffmpeg"]
        }
      }
    }
  }
};
