const { ipcMain } = require("electron");
const { spawn } = require("child_process");

const handler = () => {
  ipcMain.on("terminal", (_, data) => {
    if (process.platform === "win32") {
      spawn("start", ["cmd", "/c", "docker", "exec", "-it", data, "sh"]);
    } else {
      spawn("exo-open", [
        "--launch",
        "TerminalEmulator",
        "docker",
        "exec",
        "-it",
        data,
        "sh"
      ]);
    }
  });
  ipcMain.on("viewer", (_, data) => {
    if (process.platform === "win32") {
      spawn("virt-viewer", [`spice://localhost:${data}`]);
    } else {
      spawn("remote-viewer", [`spice://localhost:${data}`]);
    }
  });
};

module.exports = handler;
