/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CGContent.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2006-04-07 13:45:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/package com.sun.star.wizards.web.data;

import com.sun.star.wizards.common.*;

import org.w3c.dom.*;

public class CGContent         extends ConfigSetItem implements XMLProvider {
  public String dirName;

  public String      cp_Name;
  public String      cp_Description;

  public ConfigSet   cp_Contents = new ConfigSet(CGContent.class);


  public ConfigSet   cp_Documents = new ConfigSet(CGDocument.class);

  public CGContent() {
      /*cp_Documents = new ConfigSet(CGDocument.class) {
        protected DefaultListModel createChildrenList() {
            return cp_Contents.getChildrenList();
        }
      };*/

  }

  public Node createDOM(Node parent) {

      Node myElement = XMLHelper.addElement(parent,"content",
        new String[] {"name","directory-name","description","directory"},
        new String[] {cp_Name,dirName, cp_Description,dirName}
      );

      cp_Documents.createDOM(myElement);

      return myElement;
  }

}
