/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CommandName.java,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2006-04-07 12:35:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/package com.sun.star.wizards.db;

import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.JavaTools;

public class CommandName{
    protected CommandMetaData oCommandMetaData;
    protected String CatalogName = "";
    protected String SchemaName = "";
    protected String TableName = "";
    protected String DisplayName = "";
    protected String ComposedName = "";
    protected String AliasName = "";
    protected boolean bCatalogAtStart;
    protected String sCatalogSep;
    protected String sIdentifierQuote;
    protected boolean baddQuotation = true;


    public CommandName(CommandMetaData _CommandMetaData, String _DisplayName){
        oCommandMetaData = _CommandMetaData;
        setComposedCommandName(_DisplayName);
    }


    public CommandName(CommandMetaData _CommandMetaData, String _CatalogName, String _SchemaName, String _TableName, boolean _baddQuotation){
    try {
        baddQuotation = _baddQuotation;
        oCommandMetaData = _CommandMetaData;
        if ((_CatalogName != null) && (oCommandMetaData.xDBMetaData.supportsCatalogsInTableDefinitions())){
            if (!_CatalogName.equals("")){
                CatalogName = _CatalogName;
            }
        }
        if ((_SchemaName != null) && (oCommandMetaData.xDBMetaData.supportsSchemasInTableDefinitions())){
            if (!_SchemaName.equals("")){
                SchemaName = _SchemaName;
            }
        }
        if (_TableName != null){
            if (!_TableName.equals("")){
                TableName = _TableName;
            }
        }
        setComposedCommandName();
    } catch (SQLException e) {
        e.printStackTrace(System.out);
    }}


    private void setComposedCommandName(String _DisplayName) {
    try{
        if (this.setMetaDataAttributes()){
            this.DisplayName = _DisplayName;
            int iIndex;
            if (oCommandMetaData.xDBMetaData.supportsCatalogsInDataManipulation() == true) { // ...dann Catalog mit in TableName
                iIndex = _DisplayName.indexOf(sCatalogSep);
                if (iIndex >= 0) {
                    if (bCatalogAtStart == true) {
                        CatalogName = _DisplayName.substring(0, iIndex);
                        _DisplayName = _DisplayName.substring(iIndex + 1, _DisplayName.length());
                    } else {
                        CatalogName = _DisplayName.substring(iIndex + 1, _DisplayName.length());
                        _DisplayName = _DisplayName.substring(0, iIndex);
                    }
                }
            }
            if (oCommandMetaData.xDBMetaData.supportsSchemasInDataManipulation() == true) {
                String[] NameList;
                NameList = new String[0];
                NameList = JavaTools.ArrayoutofString(_DisplayName, ".");
                SchemaName = NameList[0];
                TableName = NameList[1]; // TODO Was ist mit diesem Fall: CatalogSep = "." und CatalogName = ""
            } else
                TableName = _DisplayName;
            setComposedCommandName();
    }
    } catch (Exception exception) {
        exception.printStackTrace(System.out);
    }}


    public void setComposedCommandName() {
        if (this.setMetaDataAttributes()){
            if (CatalogName != null){
                if (!CatalogName.equals("")){
                    if (bCatalogAtStart == true){
                        ComposedName = quoteName(CatalogName) + sCatalogSep;
                    }
                }
            }
            if (SchemaName != null){
                if (!SchemaName.equals(""))
                    ComposedName += quoteName(SchemaName) + ".";
            }
            if (ComposedName == "")
                ComposedName = quoteName(TableName);
            else
                ComposedName += quoteName(TableName);
            if ((bCatalogAtStart == false) && (CatalogName != null)){
                if (!CatalogName.equals(""))
                    ComposedName += sCatalogSep + quoteName(CatalogName);
            }
        }
    }


    private boolean setMetaDataAttributes(){
    try {
        bCatalogAtStart = oCommandMetaData.xDBMetaData.isCatalogAtStart();
        sCatalogSep = oCommandMetaData.xDBMetaData.getCatalogSeparator();
        sIdentifierQuote = oCommandMetaData.xDBMetaData.getIdentifierQuoteString();
        return true;
    } catch (SQLException e) {
        e.printStackTrace(System.out);
        return false;
    }}


    public String quoteName(String _sName) {
        if (baddQuotation)
            return quoteName(_sName, this.oCommandMetaData.getIdentifierQuote());
        else
            return _sName;
    }


    public static String quoteName(String sName, String _sIdentifierQuote) {
        if (sName == null)
            sName = "";
        String ReturnQuote = "";
        ReturnQuote = _sIdentifierQuote + sName + _sIdentifierQuote;
        return ReturnQuote;
    }


    public void setAliasName(String _AliasName){
        AliasName = _AliasName;
    }


    public String getAliasName(){
        return AliasName;
    }

    /**
     * @return Returns the catalogName.
     */
    public String getCatalogName() {
        return CatalogName;
    }
    /**
     * @return Returns the composedName.
     */
    public String getComposedName() {
        return ComposedName;
    }
    /**
     * @return Returns the displayName.
     */
    public String getDisplayName() {
        return DisplayName;
    }
    /**
     * @return Returns the schemaName.
     */
    public String getSchemaName() {
        return SchemaName;
    }
    /**
     * @return Returns the tableName.
     */
    public String getTableName() {
        return TableName;
    }

    public CommandMetaData getCommandMetaData(){
        return oCommandMetaData;
    }
}
