/**
 * Title:        Validation of xml files
 * Description:  Validates an xml document against a dtd<p>
 * Copyright:    null<p>
 * Company:      null<p>
 * @author       Dirk Grobler
 * @version      1.0
 */
package org.openoffice.helper;

import java.io.*;
import org.xml.sax.*;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;

public class Validator extends HandlerBase
{
    public static void main (String argv [])
    {
        if (argv.length != 1) {
            System.err.println ("Usage: cmd filename");
            System.exit (1);
        }
        // Use the validating parser
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try
        {
            // Set up output stream
            out = new OutputStreamWriter (System.out, "UTF8");

            // Parse the input
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse( new File(argv [0]), new Validator() );
        }
        catch (SAXParseException spe) {
           // Error generated by the parser
           System.out.println ("\n** Parsing error"
              + ", line " + spe.getLineNumber ()
              + ", uri " + spe.getSystemId ());
           System.out.println("   " + spe.getMessage() );
           System.exit (1);
        }
        catch (SAXException sxe) {
           // Error generated by this application
           // (or a parser-initialization error)
           Exception  x = sxe;
           if (sxe.getException() != null)
               x = sxe.getException();
           x.printStackTrace();
           System.exit (1);
        }
        catch (ParserConfigurationException pce) {
            // Parser with specified options can't be built
            pce.printStackTrace();
            System.exit (1);

        }
        catch (IOException ioe) {
           // I/O error
           ioe.printStackTrace();
           System.exit (1);
        }

        System.exit (0);
    }

    //===========================================================
    // SAX DocumentHandler methods
    //===========================================================
    public InputSource resolveEntity(java.lang.String publicId,
                                     java.lang.String systemId)
                          throws SAXException
    {
      return new InputSource(systemId);
    }

    static private Writer  out;
    //===========================================================
    // SAX DocumentHandler methods
    //===========================================================

    public void setDocumentLocator (Locator l)
    {
        // Save this to resolve relative URIs or to give diagnostics.
        try {
          out.write ("** Start validating: ");
          out.write (l.getSystemId());
          out.flush ();
        } catch (IOException e) {
            // Ignore errors
        }
    }

    public void startDocument ()
    throws SAXException
    {
    }

    public void endDocument ()
    throws SAXException
    {
        nl(); emit ("** Document is valid!");
        try {
            nl();
            out.flush ();
        } catch (IOException e) {
            throw new SAXException ("I/O error", e);
        }
    }

    //===========================================================
    // SAX ErrorHandler methods
    //===========================================================

    // treat validation errors as fatal
    public void error (SAXParseException e)
    throws SAXParseException
    {
        throw e;
    }

    // dump warnings too
    public void warning (SAXParseException err)
    throws SAXParseException
    {
        System.out.println ("** Warning"
            + ", line " + err.getLineNumber ()
            + ", uri " + err.getSystemId ());
        System.out.println("   " + err.getMessage ());
    }

    //===========================================================
    // Helpers ...
    //===========================================================

    // Wrap I/O exceptions in SAX exceptions, to
    // suit handler signature requirements
    private void emit (String s)
    throws SAXException
    {
        try {
            out.write (s);
            out.flush ();
        } catch (IOException e) {
            throw new SAXException ("I/O error", e);
        }
    }

    // Start a new line
    // and indent the next line appropriately
    private void nl ()
    throws SAXException
    {
        String lineEnd =  System.getProperty("line.separator");
        try {
            out.write (lineEnd);
        } catch (IOException e) {
            throw new SAXException ("I/O error", e);
        }
    }
}
