/*************************************************************************
 *
 *  $RCSfile: MConnection.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: vg $ $Date: 2005-02-21 12:21:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CONNECTIVITY_SCONNECTION_HXX
#define CONNECTIVITY_SCONNECTION_HXX

#ifndef _CONNECTIVITY_MAB_COLUMNALIAS_HXX_
#include "MColumnAlias.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_CATALOG_HXX_
#include "MCatalog.hxx"
#endif



#ifndef _COM_SUN_STAR_SDBC_SQLWARNING_HPP_
#include <com/sun/star/sdbc/SQLWarning.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _CONNECTIVITY_OSUBCOMPONENT_HXX_
#include "OSubComponent.hxx"
#endif
//  #include <map>
#ifndef _COM_SUN_STAR_SDBCX_XTABLESSUPPLIER_HPP_
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#endif
#ifndef _CONNECTIVITY_COMMONTOOLS_HXX_
#include "connectivity/CommonTools.hxx"
#endif
#ifndef CONNECTIVITY_CONNECTION_HXX
#include "TConnection.hxx"
#endif
#ifndef _CPPUHELPER_WEAKREF_HXX_
#include <cppuhelper/weakref.hxx>
#endif
#ifndef _COM_SUN_STAR_MOZILLA_MOZILLPRODUCTTYPE_HPP_
#include <com/sun/star/mozilla/MozillaProductType.hpp>
#endif

namespace connectivity
{
    namespace mozab
    {

        class OStatement_Base;
        class MozabDriver;
        class ODatabaseMetaData;
        class MNameMapper;

        namespace SDBCAddress {
            typedef enum {
                Unknown     = 0,
                Mozilla     = 1,
                ThunderBird = 2,
                LDAP        = 3,
                Outlook     = 4,
                OutlookExp  = 5
            } sdbc_address_type;
        }

        // For the moment, we will connect the Mozilla address book to the Mozilla
        // top-level address book which will display whatever is in the preferences
        // file of Mozilla.
        // This one is a base uri which will be completed with the connection data.
        static sal_Char*    MOZ_SCHEME_MOZILLA          = "moz-abdirectory://";
        // This one is for mozilla native address book
        static sal_Char*    MOZ_SCHEME_MOZILLA_MDB      = "moz-abmdbdirectory://";
        // This one is for LDAP address book
        static sal_Char*    MOZ_SCHEME_LDAP             = "moz-abldapdirectory://";
        // These two uris will be used to obtain directory factories to access all
        // address books of the given type.
        static sal_Char*    MOZ_SCHEME_OUTLOOK_MAPI     = "moz-aboutlookdirectory://op/";
        static sal_Char*    MOZ_SCHEME_OUTLOOK_EXPRESS  = "moz-aboutlookdirectory://oe/";

        typedef connectivity::OMetaConnection               OConnection_BASE; // implements basics and text encoding

        class OConnection : public OConnection_BASE,
                            public connectivity::OSubComponent<OConnection, OConnection_BASE>
        {
            friend class connectivity::OSubComponent<OConnection, OConnection_BASE>;

        protected:
            //====================================================================
            // Data attributes
            //====================================================================
            ::com::sun::star::uno::WeakReference< ::com::sun::star::sdbc::XDatabaseMetaData > m_xMetaData;

            connectivity::OWeakRefArray             m_aStatements;  //  vector containing a list
                                                        //  of all the Statement objects
                                                        //  for this Connection

            ::com::sun::star::sdbc::SQLWarning      m_aLastWarning; //      Last SQLWarning generated by
                                                        //  an operation
            MozabDriver*                            m_pDriver;      //  Pointer to the owning
                                                                    //  driver object
            // Store Catalog
            ::com::sun::star::uno::Reference< ::com::sun::star::sdbcx::XTablesSupplier>         m_xCatalog;
            // Start of Additions from the land of mozilla
            OColumnAlias    m_aColumnAlias;
            rtl::OUString   m_sMozillaURI;
            rtl::OUString   m_sMozillaProfile;
            sal_Int32       m_nMaxResultRecords;
            MNameMapper*    m_aNameMapper;
            //LDAP only
            rtl::OUString   m_sHostName;
            sal_Bool        m_bUseSSL;
            rtl::OUString   m_sBindDN;
            rtl::OUString   m_sUser;        // the user name
            rtl::OUString   m_sPassword;



            SDBCAddress::sdbc_address_type  m_eSDBCAddressType;

            sal_Bool        m_bForceLoadTable;

        public:
            virtual void construct( const ::rtl::OUString& url,const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& info) throw(::com::sun::star::sdbc::SQLException);
            OConnection(MozabDriver*    _pDriver);
            virtual ~OConnection();

            void closeAllStatements () throw( ::com::sun::star::sdbc::SQLException);

            // OComponentHelper
            virtual void SAL_CALL disposing(void);
            // XInterface
            virtual void SAL_CALL release() throw();

            // XServiceInfo
            DECLARE_SERVICE_INFO();
            // XConnection
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XStatement > SAL_CALL createStatement(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareStatement( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareCall( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::rtl::OUString SAL_CALL nativeSQL( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setAutoCommit( sal_Bool autoCommit ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL getAutoCommit(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL commit(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL rollback(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL isClosed(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData > SAL_CALL getMetaData(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setReadOnly( sal_Bool readOnly ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL isReadOnly(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setCatalog( const ::rtl::OUString& catalog ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::rtl::OUString SAL_CALL getCatalog(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setTransactionIsolation( sal_Int32 level ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Int32 SAL_CALL getTransactionIsolation(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > SAL_CALL getTypeMap(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setTypeMap( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& typeMap ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            // XCloseable
            virtual void SAL_CALL close(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            // XWarningsSupplier
            virtual ::com::sun::star::uno::Any SAL_CALL getWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL clearWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            //
            MozabDriver*    getDriver() const { return m_pDriver;}

            // Added to enable me to use SQLInterpreter which requires an
            // XNameAccess i/f to access tables.
            ::com::sun::star::uno::Reference< ::com::sun::star::sdbcx::XTablesSupplier > SAL_CALL createCatalog();


            // Additions from the land of mozilla
            rtl::OUString getMozURI() const     { return m_sMozillaURI; }
            rtl::OUString getMozProfile() const     { return m_sMozillaProfile; }
            void setMozProfile(rtl::OUString &aNewProfile)      { m_sMozillaProfile = aNewProfile; }

            ::com::sun::star::mozilla::MozillaProductType getProduct()
            {
                if (m_eSDBCAddressType == SDBCAddress::ThunderBird)
                    return ::com::sun::star::mozilla::MozillaProductType_Thunderbird;
                return ::com::sun::star::mozilla::MozillaProductType_Mozilla;
            }

            // Get Ldap BindDN (user name)
            rtl::OUString getBindDN() const { return m_sBindDN; }
            // Get Ldap Password
            rtl::OUString getPassword() const { return m_sPassword; }
            // Get Ldap Host name
            rtl::OUString getHost() const { return m_sHostName; }
            // Get whether use ssl to connect to ldap
            sal_Bool getUseSSL() const {return m_bUseSSL;}

            sal_Bool usesFactory(void) const { return (m_eSDBCAddressType == SDBCAddress::Outlook) || (m_eSDBCAddressType == SDBCAddress::OutlookExp); }
            sal_Bool isLDAP(void) const { return m_eSDBCAddressType == SDBCAddress::LDAP; }
            sal_Bool isThunderbird(void) const { return m_eSDBCAddressType == SDBCAddress::ThunderBird; }

            sal_Bool    isOutlookExpress() const { return m_eSDBCAddressType == SDBCAddress::OutlookExp;}
            sal_Int32   getMaxResultRecords() const { return m_nMaxResultRecords; }

            SDBCAddress::sdbc_address_type getSDBCAddressType() const { return m_eSDBCAddressType;}

            const OColumnAlias & getColumnAlias() const   { return (m_aColumnAlias); }

            static const sal_Char*    getSDBC_SCHEME_MOZILLA();
            static const sal_Char*    getSDBC_SCHEME_THUNDERBIRD();
            static const sal_Char*    getSDBC_SCHEME_LDAP();
            static const sal_Char*    getSDBC_SCHEME_OUTLOOK_MAPI();
            static const sal_Char*    getSDBC_SCHEME_OUTLOOK_EXPRESS();
            static ::rtl::OUString    getDriverImplementationName();

            MNameMapper* getNameMapper();
            void setForceLoadTables(sal_Bool aForce){ m_bForceLoadTable = aForce;}
            sal_Bool getForceLoadTables() { return m_bForceLoadTable;}

            // End of Additions from the land of mozilla
        };
    }
}
#endif // CONNECTIVITY_SCONNECTION_HXX

