<?php
/**
 * Template Name: Katkı Sağla / Öneride Bulun
 */
    get_header();


    $current_page_parent = '';
    $current_page_ID = $post->ID;


    if ( $post->post_parent > 0 ) {
        $current_page_parent = $post->post_parent;

    } else {
        $current_page_parent = $post->ID;

    }


    // Instead of calling and passing query parameter differently, we're doing it exclusively
    $all_posts = get_pages( array(
        'post_type'     => 'page', // here's my CPT
    ) );

    // echo $current_page_parent;

    // Using the function
    $inherited_posts = get_page_children( $current_page_parent, $all_posts );
    
    // echo what we get back from WP to the browser (@bhlarsen's part :) )
    // echo '' . print_r( $inherited_posts, true ) . '';
?>

    <!-- Middle Content -->
    <div class="m-content">

        <!-- Breadcrumb -->
        <?php echo breadcrumb(); ?>


        <!-- Tab System -->
        <div class="tab-system">

            <!-- Tab Nav -->
            <ul class="tab-nav d-flex">
                <li><a href="<?php echo get_permalink($pd_option['page_katki_sagla']); ?>" class="d-flex align-items-center justify-content-center <?php echo $current_page_parent == $pd_option['page_katki_sagla'] ? 'active': null; ?>">Katkı Sağla</a></li>
                <li><a href="https://talep.pardus.org.tr/servicedesk/customer/portal/1/group/36" target="_blank" class="d-flex align-items-center justify-content-center">Öneride Bulun</a></li>
            </ul>

            <!-- Tab Nav -->
            <ul class="tab-nav d-flex">
                <?php
                    if ( $inherited_posts ) {
                        foreach ( $inherited_posts as $key => $value ) {
                            // echo '<li class="' . ( $current_page_ID == $value->ID ? 'current-menu-item': null ) . '"><a href="' . get_the_permalink($value->ID) . '" class="d-flex align-items-center justify-content-center">' . $value->post_title . '</a></li>';
                            echo '<li><a href="javascript:;" class="d-flex align-items-center justify-content-center ' . ( ( $current_page_ID == $value->ID ) || ( $current_page_parent == $current_page_ID && $key == 0 ) ? 'active': null ) . '" onclick="tabNav.call(this, \'' . $value->post_name . '\');">' . $value->post_title . '</a></li>';
                        }
                    }
                ?>
                <!-- <li><a href="javascript:;" class="d-flex align-items-center justify-content-center active" onclick="tabNav.call(this, 'belgelendirme');">Belgelendirme</a></li> -->
                <!-- <li><a href="javascript:;" class="d-flex align-items-center justify-content-center" onclick="tabNav.call(this, 'yazilim');">Yazılım</a></li> -->
                <!-- <li><a href="javascript:;" class="d-flex align-items-center justify-content-center" onclick="tabNav.call(this, 'yerellestirme');">Yerelleştirme</a></li> -->
                <!-- <li><a href="javascript:;" class="d-flex align-items-center justify-content-center" onclick="tabNav.call(this, 'tasarim');">Tasarım</a></li> -->
                <!-- <li><a href="javascript:;" class="d-flex align-items-center justify-content-center" onclick="tabNav.call(this, 'test');">Test</a></li> -->
            </ul>

            <!-- Tab Content -->
            <div class="tab-content">

                <?php
                    if ( $inherited_posts ) {
                        foreach ( $inherited_posts as $key => $post ) {

                            setup_postdata($post);


                            $featured_img_url = get_the_post_thumbnail_url( $post->ID, 'full' ); 

                ?>
                    <!-- Tab: Belgelendirme -->
                    <div class="tab tab-<?php echo $post->post_name; ?> <?php echo ( $current_page_ID == $post->ID ) || ( $current_page_parent == $current_page_ID && $key == 0 ) ? 'in': null; ?>">

                        <!-- Blog Detail -->
                        <div class="blog-content page">

                            <!-- Blog Thumbnail -->
                            <?php if ( $featured_img_url ) { ?>
                                <div class="thumb">
                                    <!-- <img src="<?php echo $featured_img_url; ?>" class="d-block border-radius img-responsive" alt="<?php echo $post->post_title; ?>" /> -->
                                    <?php the_post_thumbnail( 'full', array( 'class' => 'd-block border-radius img-responsive', 'alt' => get_the_title() ) ); ?>
                                </div>
                            <?php } ?>

                            <!-- Content Area -->
                            <div class="content-area d-flex flex-column flex-md-row align-items-start">

                                <!-- Content Right -->
                                <div class="ca-right">

                                    <!-- Content -->
                                    <div class="post-content">

                                        <?php the_content(); ?>

                                        <?php if ( $pd_option['page_oneride_bulun'] != $current_page_parent ) { ?>
                                           <?php $meta = get_post_meta( $id, '_page_settings', true ); ?>
                                            <div class="btns d-flex justify-content-center">
                                                <?php if ( $meta['page_ayrintili_bilgi'] ) { ?><a href="<?php echo $meta['page_ayrintili_bilgi']; ?>" target="_blank" class="btn btn-filled">Ayrıntılı Bilgi</a><?php } ?>
                                                <?php if ( $meta['page_basvuru'] ) { ?> <a href="<?php echo $meta['page_basvuru']; ?>" target="_blank" class="btn btn-filled">Başvuru</a><?php } ?>
                                            </div>
                                        <?php } ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                <?php
                        }
                    }
                ?>


            </div>

        </div>


    </div>


<?php get_footer(); ?>