<?php
    get_header();

    if ( have_posts() ): the_post();
?>
    <!-- Middle Content -->
    <div class="m-content">

        <!-- Breadcrumb -->
        <?php echo breadcrumb(); ?>

        <!-- Blog Detail -->
        <div class="blog-content">
            <!-- Title -->
            <h1 class="title"><?php the_title(); ?></h1>

            <!-- Blog Thumbnail -->
            <div class="thumb">
                <?php the_post_thumbnail( 'full', array( 'class' => 'd-block border-radius img-responsive', 'alt' => get_the_title() ) ); ?>
            </div>


            <!-- Author -->
            <div class="author d-flex align-items-center justify-content-between">
                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="author-details d-flex align-items-center">
                    <span class="a-image">
                        <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ) ) ); ?>" alt="<?php echo get_the_author(); ?>" width="42" height="42" class="d-block border-radius" />
                    </span>

                    <span class="a-details">
                        <span class="a-name d-flex"><?php echo get_the_author(); ?></span>
                        <span class="a-role d-flex"><?php echo esc_attr(get_the_author_meta( 'user_title', get_the_author_meta( 'ID' ) )); ?></span>
                    </span>
                </a>
                <div class="date"><?php the_date('d F Y'); ?></div>
            </div>


            <!-- Content Area -->
            <div class="content-area d-flex flex-column flex-sm-row align-items-start">
                <div class="ca-sidebar">
                    <!-- Share Buttons -->
                    <div class="share d-flex flex-row flex-sm-column align-items-center justify-content-between justify-content-lg-center">
                        <div class="s-title">Paylaş</div>

                        <ul class="d-flex flex-row flex-sm-column">
                            <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>&t=<?php the_title(); ?>" class="d-block border-radius"><img src="<?php bloginfo('template_url'); ?>/assets/icons/fbc.svg" alt="fbc" class="d-block svg" width="20" height="20" /></a></li>
                            <li><a href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>" class="d-block border-radius"><img src="<?php bloginfo('template_url'); ?>/assets/icons/twc.svg" alt="twc" class="d-block svg" width="20" height="20" /></a></li>
                            <li><a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" class="d-block border-radius"><img src="<?php bloginfo('template_url'); ?>/assets/icons/linkc.svg" alt="linkc" class="d-block svg" width="20" height="20" /></a></li>
                        </ul>
                    </div>
                </div>

                <!-- Content Right -->
                <div class="ca-right">

                    <!-- Content -->
                    <div class="post-content">
                        <?php
                            if ( has_excerpt() ) {
                                the_excerpt();
                            }

                            the_content();
                        ?>
                    </div>

                    <!-- Author Card -->
                    <div class="author-card d-flex">
                        <div class="author-img d-none d-md-inline">
                            <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ), array( 'size' => 128 ) ) ); ?>" alt="<?php echo get_the_author(); ?>" width="128" height="128" class="d-block border-radius author-img-in" />
                        </div>
                        <div class="author-details">
                            <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ), array( 'size' => 128 ) ) ); ?>" alt="<?php echo get_the_author(); ?>" width="128" height="128" class="d-block d-md-none border-radius author-img-in" />
                            <div class="author-name"><?php echo get_the_author(); ?></div>
                            <div class="author-info"><?php the_author_meta('description'); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

<?php endif; get_footer(); ?>