<?php

    global $post;

    setup_postdata($post);

?>
<!-- Blog Card -->
<div class="blog-card border-radius">
    <a href="<?php the_permalink(); ?>" class="row align-items-center">
        <span class="col col-img">
            <?php the_post_thumbnail( 'i290x220', array( 'class' => 'img-responsive border-radius', 'alt' => get_the_title() ) ); ?>
        </span>
        <span class="col d-flex flex-column">
            <span class="title"><?php the_title(); ?></span>
            <span class="desc"><?php the_excerpt(); ?></span>
            <span class="date"><span class="text-yellow"><?php echo esc_html( human_time_diff( get_the_time('U'), current_time('timestamp') ) ) . ' önce'; ?></span> - <?php echo reading_time(); ?></span>
        </span>
    </a>
</div>