<?php
    global $pd_option;
    get_header();
?>

    <!-- Middle Content -->
    <div class="m-content">

        <!-- Breadcrumb -->
        <?php echo breadcrumb(); ?>

        <!-- Head Banner -->
        <?php get_template_part('modules/m-head-banner'); ?>

        <!-- Tab System -->
        <?php if ( $pd_option['home_categories'] ) { ?>
            <div class="tab-system">
                
                <!-- Tab Nav -->
                <ul class="tab-nav d-flex">
                    <?php $i = 0; foreach ( $pd_option['home_categories'] as $cat ) { ?>
                        <li><a href="javascript:;" class="d-flex align-items-center justify-content-center <?php echo $i == 0 ? 'active': null; ?>" onclick="tabNav.call(this, '<?php echo post_slug($cat['title']); ?>');"><?php echo $cat['title']; ?></a></li>
                    <?php $i++; } ?>
                </ul>

                <!-- Tab Content -->
                <div class="tab-content">
                    <?php $i = 0; foreach ( $pd_option['home_categories'] as $cat ) { ?>
                        <!-- Tab: Nasıl -->
                        <div class="tab tab-<?php echo post_slug($cat['title']); ?> <?php echo $i == 0 ? 'in': null; ?>">

                            <!-- Tab Title Area -->
                            <div class="tab-title-area d-flex align-items-center justify-content-between">
                                <!-- Title -->
                                <div class="t-title"><?php echo $cat['title']; ?></div>

                                <!-- Link -->
                                <a href="<?php echo get_category_link($cat['cat_id']); ?>" class="t-link">Tüm <?php echo $cat['title']; ?> İçeriklerini İnceleyin</a>
                            </div>

                            <!-- Blog Card List -->
                            <div class="blog-card-list">

                                <?php

                                    $args = array(
                                        'post_type' => 'post',
                                        'posts_per_page' => $cat['count'],
                                        'cat' => $cat['cat_id'],
                                    );

                                    $wp_query = new WP_Query($args);

                                    if ( $wp_query->have_posts() ) :
                                        while ( $wp_query->have_posts() ) :
                                            $wp_query->the_post();

                                            get_template_part('modules/blog', 'card');

                                        endwhile;
                                    endif;
                                    wp_reset_query();

                                ?>

                            </div>

                        </div>
                    <?php $i++; } ?>

                </div>

            </div>
        <?php } ?>

    </div>

<?php get_footer(); ?>