<?php global $pd_option; ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-sv">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0" />


    <!-- <meta name="theme-color" content="#131313" media="(prefers-color-scheme: light)"> -->
    <!-- <meta name="theme-color" content="#131313" media="(prefers-color-scheme: dark)"> -->

    <title><?php wp_title(''); ?></title>

    <link href="<?php bloginfo('template_url'); ?>/assets/imgs/favicon.png" rel="icon" type="image/png" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@400;700&display=swap" rel="stylesheet" />


    <?php wp_head(); ?>
</head>
<body <?php body_class('d-flex container-huge'); ?>>


    <!-- Left Side -->
    <div id="left-side">

        <!-- Logo -->
        <a href="<?php echo home_url('/'); ?>" class="logo d-flex justify-content-center" title="pardus">
            <img src="<?php bloginfo('template_url'); ?>/assets/imgs/logo-yatay.svg" width="150" height="45" alt="pardus" class="logo" />
        </a>

        <!-- M. Header Right Form -->
        <form action="<?php echo home_url('/'); ?>" method="GET" class="mh-right-form border-radius d-flex d-lg-none align-items-center">
            <input type="text" class="form-control" placeholder="Arama yapın" name="s" value="<?php echo get_query_var('s'); ?>" />
            <button type="submit" class="icon d-flex align-items-center justify-content-center"><img src="<?php bloginfo('template_url'); ?>/assets/icons/search-loap.svg" class="svg" alt="search-loap" width="24" height="24" /></button>
        </form>

        <!-- Member Card -->
        <?php // get_template_part('modules/member-card', '', array( 'class' => 'd-lg-none d-block' )); ?>


        <!-- Menu -->
        <!-- <ul class="header-menu">
            <li class="current-menu-item"><a href="index.html" class="menu-anasayfa">Anasayfa</a></li>
            <li><a href="#" class="menu-nasil">Nasıl?</a></li>
            <li><a href="#" class="menu-haberler">Haberler</a></li>
            <li><a href="blog.html" class="menu-blog">Blog</a></li>
            <li><a href="page-destek.html" class="menu-destek-olun">Destek Olun</a></li>
            <li><a href="#" class="menu-forum">Forum</a></li>
        </ul> -->
        <?php 
            wp_nav_menu(
                array(
                    'menu'    => 'left-menu',
                    'theme_location' => 'left-menu',
                    'depth'    => 4,
                    'container'   => 'ul',
                    'container_class' => '',
                    'container_id'  => '',
                    'menu_class'  => 'header-menu',
                    'fallback_cb'  => '',
                )
            );
        ?>

        <!-- Download -->
        <div class="download  d-flex flex-column align-items-center">
            <img src="<?php bloginfo('template_url'); ?>/assets/imgs/pardus-notebook.png" alt="pardus-notebook" />

            <a href="<?php echo $pd_option['link_pardus_download']; ?>" class="btn btn-filled d-flex">Pardus'u İndirin</a>
        </div>

        <!-- Social Links -->
        <div class="footer-social-icons d-flex align-items-center justify-content-center">
        <?php foreach ( $pd_option['social-media'] as $social ) { ?>
            <a href="<?php echo $social['sm-link']; ?>" target="_blank" class="icon-link d-flex align-items-center justify-content-center border-radius"><img src="<?php echo get_template_directory_uri() . '/assets/pardus-sm/' . $social['sm-image']; ?>" alt="instagram" class="svg d-block" height="24" width="24" /></a>
        <?php } ?>
        </div>

    </div>

    <!-- Middle Side -->
    <div id="middle-side" class="d-flex flex-column">

        <!-- Backdrop -->
        <div class="backdrop" onclick="closeMobileMenu();"></div>

        <!-- Middle Top -->
        <div class="m-top">

            <!-- Middle Header -->
            <div class="m-header d-flex align-items-center justify-content-between">
                <!-- M. Header Left -->
                <div class="mh-left">Pardus Topluluk Portalı</div>

                <!-- M. Header Right Form -->
                <form action="<?php echo home_url('/'); ?>" method="GET" class="mh-right-form border-radius d-flex align-items-center">
                    <input type="text" class="form-control" placeholder="Arama yapın" name="s" value="<?php echo get_query_var('s'); ?>" />
                    <button type="submit" class="icon d-flex align-items-center justify-content-center"><img src="<?php bloginfo('template_url'); ?>/assets/icons/search-loap.svg" class="svg" alt="search-loap" width="24" height="24" /></button>
                </form>
            </div>

            <div class="m-mobil-header d-lg-none d-flex">

                <a href="<?php echo home_url('/'); ?>" class="mobil-logo">
                    <img src="<?php bloginfo('template_url'); ?>/assets/imgs/logo-yatay.svg" width="133" height="48" alt="pardus" class="img-responsive" />
                </a>

                <a href="javascript:;" onclick="openMobileMenu();" class="mobile-hamburger-menu d-flex d-lg-none">
                    <div class="hamburger-menu"></div>
                </a>

            </div>

            <!-- Marquee -->
            <!-- TODO: API ile baglanacak -->
            <!-- <div class="marquee">
                <ul class="d-flex">
                    <li><a href="#">Pardus Forum’dan son girilen yazı</a></li>
                    <li><a href="#">Pardus Forum’dan son girilen yazı</a></li>
                    <li><a href="#">Pardus Forum’dan son girilen yazı</a></li>
                    <li><a href="#">Pardus Forum’dan son girilen yazı</a></li>
                    <li><a href="#">Pardus Forum’dan son girilen yazı</a></li>
                </ul>
            </div> -->
