<?php
error_reporting(1);

// date_default_timezone_set('Europe/Istanbul');

define( 'LANG', 'pd' );
define( 'PEND_PREFIX', 'pd' );
define( 'REST_NAME', 'theme/v1' );
// setlocale(LC_ALL, 'tr_TR');

global $pd_option, $theme_version;
$theme_version = wp_get_theme()->get('Version');
$pd_option = get_option('_cs_options');



require_once get_template_directory() . '/cs-framework/cs-framework.php';
include 'scripts/meta-box/config-meta-boxes.php';
include 'ajax.php';


/*-----------------------------------------------------------------------------------*/
/*	Include Meta Box
/*-----------------------------------------------------------------------------------*/
// define( 'RWMB_URL', trailingslashit( get_template_directory_uri() . '/scripts/meta-box' ) );
// define( 'RWMB_DIR', trailingslashit( get_template_directory() . '/scripts/meta-box' ) );
// require_once RWMB_DIR . 'meta-box.php';
// require_once RWMB_DIR . 'config-meta-boxes.php';

// include 'scripts/rest-api.php';

// Remove HTML Tags from Excerpt
// remove_filter( 'the_excerpt', 'wpautop' );

// Hide Wordpress Version
remove_action('wp_head', 'wp_generator');

// Remove Canonical Meta
remove_action('wp_head', 'rel_canonical');

// Support to Mail
add_filter( 'wp_mail_content_type', function( $content_type ) { return 'text/html'; } );
add_filter( 'wp_mail_from_name', function( $name ) { return get_bloginfo('name'); } );

// Remove Br and P on Contact Form 7
add_filter('wpcf7_autop_or_not', '__return_false');


## $_POST
function p($par, $st = false) {
	if ($st) {
		return htmlspecialchars(addslashes(trim($_POST[$par])));
	} else {
		return addslashes(trim($_POST[$par]));
	}
}

## $_GET
function g($par) {
	return strip_tags(trim(addslashes($_GET[$par])));
}


/**
	After Theme Setup
**/
// function my_theme_setup(){

// 	/**
// 		Language
// 	**/
// 	load_theme_textdomain(LANG, get_template_directory() . '/lang');

// }
// add_action('after_setup_theme', 'my_theme_setup');



// Öne çıkartılmış görsel
add_theme_support('post-thumbnails');
add_image_size( 'i290x220', 290, 220, true );
add_image_size( 'i800x300', 800, 300, true );
// add_image_size( 'i1263x446', 1263, 446, true );
// add_image_size( 'i420x400', 420, 400, true );
// add_image_size( 'i1920x1190', 1920, 1190, true );


 /** 
 * Removes the default wordpress image styles 
 * this prevents wordpress to generate other size of image for uploaded image 
 * 
 * Hooked to intermediate_image_sizes_advanced filter 
 * See wp_generate_attachment_metadata( $attachment_id, $file ) in wp-admin/includes/image.php 
 * 
 * @param $sizes, array of default and added image sizes 
 * @return $sizes, modified array of image sizes 
 * @author Pawan Kumar http://www.w3-learn.com 
 */
/*
function w3learn_filter_image_sizes( $sizes ) {

	unset($sizes['thumbnail']);
	unset($sizes['medium']);
	unset($sizes['large']);

	return $sizes;
}
add_filter('intermediate_image_sizes_advanced', 'w3learn_filter_image_sizes');  
*/


function add_menu() {
	register_nav_menu( 'left-menu', __( 'Sol Menü', LANG ) );
	register_nav_menu( 'footer-menu', __( 'Footer Menü', LANG ) );
}
add_action( 'init', 'add_menu' );



// Custom Logo for Login Page
function custom_loginlogo() {
	echo '<style type="text/css">
            .login h1 a {
                background-image: url(' . get_bloginfo('template_url') . '/assets/imgs/logo@1x.png) !important;
                background-size: contain;
                width: 100%;
            }
		</style>';
}
add_action('login_head', 'custom_loginlogo');


/* -------------------------------------------------------------------------- */
/* inline Css */
/* -------------------------------------------------------------------------- */
function head_css(){
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	global $pd_option;
	echo '<style>';
		// include('assets/styles/css/reset.css');
		// include('assets/styles/css/grid.css');

		echo $pd_option['custom_css'];

	echo '</style>';

	echo $pd_option['custom_js'] ? '<script>' . $pd_option['custom_js'] . '</script>': null;
}
add_action('wp_head', 'head_css', 0);


/* -------------------------------------------------------------------------- */
/* Footer Scripts */
/* -------------------------------------------------------------------------- */
function footer_scripts(){
	global $pd_option;
	echo "\n" . $pd_option['footer_scripts'];

	if ( is_page() ) {
		global $post;

		$page_settings = get_post_meta($post->ID, '_page_settings', true);

		echo "\n" . $page_settings['script_ext'];

	}
}
add_action('wp_footer', 'footer_scripts');

// Register CSS & JS
function pd_enqueue_styles(){
	global $pd_option, $theme_version;

	// include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	// $v = rand(1000, 9999);
	$v = $theme_version;

	// Remove Scripts
	if ( !is_admin() ) {
		wp_deregister_script('jquery');
		wp_deregister_script('jquery-migrate');
		wp_deregister_style('wp-block-library');
	}
	
	
	// wp_deregister_style('contact-form-7');
	

	// CSS
	wp_register_style( PEND_PREFIX . '-reset', get_stylesheet_directory_uri() . '/assets/styles/css/reset.css', array(), $v );
	wp_register_style( PEND_PREFIX . '-grid', get_stylesheet_directory_uri() . '/assets/styles/css/grid.css', array(), $v );
	wp_register_style( PEND_PREFIX . '-app', get_stylesheet_directory_uri() . '/assets/styles/css/app.css', array(), $v );
	wp_register_style( PEND_PREFIX . '-responsive', get_stylesheet_directory_uri() . '/assets/styles/css/responsive.css', array(), $v );
	wp_register_style( PEND_PREFIX . '-owl', get_stylesheet_directory_uri() . '/assets/lib/OwlCarousel2/assets/owl.carousel.min.css', array(), '1.0' );
	wp_register_style( PEND_PREFIX . '-default', get_stylesheet_directory_uri() . '/assets/lib/OwlCarousel2/assets/owl.theme.default.min.css', array(), $v );


	wp_enqueue_style( PEND_PREFIX . '-reset' );
	wp_enqueue_style( PEND_PREFIX . '-grid' );
	wp_enqueue_style( PEND_PREFIX . '-app' );
	wp_enqueue_style( PEND_PREFIX . '-responsive' );
	wp_enqueue_style( PEND_PREFIX . '-owl' );
	wp_enqueue_style( PEND_PREFIX . '-default' );


	// JS
	// <!-- Scripts -->
	wp_register_script( 'jquery', get_stylesheet_directory_uri() . '/assets/js/jquery.min.js', false, '2.1.4', true  );
	// wp_register_script( PEND_PREFIX . '-marquee', get_stylesheet_directory_uri() . '/assets/js/jquery.marquee.min.js', false, '', true  );
	wp_register_script( PEND_PREFIX . '-owljs', get_stylesheet_directory_uri() . '/assets/lib/OwlCarousel2/owl.carousel.min.js', false, '2.3.4', true  );
	wp_register_script( PEND_PREFIX . '-app', get_stylesheet_directory_uri() . '/assets/js/app.js', false, $v, true  ); // defer

	if ( !is_admin() ) {
		wp_enqueue_script( 'jquery' );
	}
	// wp_enqueue_script( PEND_PREFIX . '-marquee' );
	wp_enqueue_script( PEND_PREFIX . '-owljs' );
	wp_enqueue_script( PEND_PREFIX . '-app' );
	wp_localize_script( PEND_PREFIX . '-app', 'pd', array(
		'ver' => $v,
		// 'home_url' => home_url(),
		// 'plugins_url' => plugins_url(),
		// 'rest_url' => get_rest_url( null, REST_NAME ),
		'ajax_url' => admin_url( 'admin-ajax.php' ),
		'forum_url' => $pd_option['link_forum'],
		// 'template_url' => get_bloginfo( 'template_url' ),
		// 'map_api' => $pd_option['map_api'],
	));

}
add_action('wp_enqueue_scripts', 'pd_enqueue_styles', 10);

function disable_embeds_code_init() {

    if ( !is_admin() ) {

        // Remove the REST API endpoint.
        remove_action( 'rest_api_init', 'wp_oembed_register_route' );
    
        // Turn off oEmbed auto discovery.
        add_filter( 'embed_oembed_discover', '__return_false' );
    
        // Don't filter oEmbed results.
        remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );
    
        // Remove oEmbed discovery links.
        remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
    
        // Remove oEmbed-specific JavaScript from the front-end and back-end.
        remove_action( 'wp_head', 'wp_oembed_add_host_js' );
        add_filter( 'tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin' );
    
        // Remove all embeds rewrite rules.
        add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
    
        // Remove filter of the oEmbed result before any HTTP requests are made.
        remove_filter( 'pre_oembed_result', 'wp_filter_pre_oembed_result', 10 );
    }
}
add_action( 'init', 'disable_embeds_code_init', 9999 );


// Add Preload to wp_head
// function addToPreload($url, $v) {
// 	// global $url, $v;
// 	add_action( 'wp_head', function() use ( $url, $v ) {
// 		// global $url, $v;
// 		echo "\n";
// 		echo '<link rel="preload" href="' . $url . '?ver=' . $v . '" as="style" />';
// 	}, 10);
// }


// Register Post Types
/*
function register_themepost() { 

	// Maç Fikstürü
	$args = array(
		'labels' => array(
			'name'                  => _x( 'Maç Fikstürü', 'Post type general name', LANG ),
			'singular_name'         => _x( 'Maç Fikstürü', 'Post type singular name', LANG ),
			'menu_name'             => _x( 'Maç Fikstürü', 'Admin Menu text', LANG ),
			'name_admin_bar'        => _x( 'Maç Fikstürü', 'Add New on Toolbar', LANG ),
			'add_new'               => __( 'Yeni Maç Ekle', LANG ),
			'add_new_item'          => __( 'Yeni Maç', LANG ),
			'new_item'              => __( 'Yeni Maç', LANG ),
			'edit_item'             => __( 'Maç Fikstürü Bilgileri', LANG ),
			'view_item'             => __( 'Maç Fikstürünü Görüntüle', LANG ),
			'all_items'             => __( 'Tüm Maç Fikstürü', LANG ),
			'search_items'          => __( 'Ara', LANG ),
			'parent_item_colon'     => __( 'Ebeveyn Maç Fikstürü:', LANG ),
			'not_found'             => __( 'Maç Fikstürü bulunamadı.', LANG ),
			'not_found_in_trash'    => __( 'Çöp kutusunda Maç Fikstürü bulunamadı.', LANG ),
			// 'featured_image'        => _x( 'Maç Fikstürü Fotoğrafı', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', LANG ),
			// 'set_featured_image'    => _x( 'Fotoğraf seç', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', LANG ),
			// 'remove_featured_image' => _x( 'Fotoğrafı kaldır', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', LANG ),
			// 'use_featured_image'    => _x( 'Maç Fikstürü Fotoğrafı olarak kullan', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', LANG ),
			'archives'              => _x( 'Maç Fikstürü arşivleri', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', LANG ),
			// 'insert_into_item'      => _x( 'Insert into recipe', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', LANG ),
			// 'uploaded_to_this_item' => _x( 'Uploaded to this recipe', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', LANG ),
			// 'filter_items_list'     => _x( 'Filter recipes list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', LANG ),
			// 'items_list_navigation' => _x( 'Recipes list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', LANG ),
			'items_list'            => _x( 'Maç Fikstürü listesi', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', LANG ),
		),
		'hierarchical' => false,
		'description' => 'Maç Fikstürü',
		'supports' => array( 'title' ),
		// 'taxonomies' => array('ilan_kategori'),
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_icon' => 'dashicons-calendar-alt',
		'show_in_nav_menus' => true,
		'publicly_queryable' => true,
		'exclude_from_search' => true,
		'query_var' => true,
		'can_export' => true,
		'rewrite' => array('slug' => 'mac', 'with_front' => FALSE),
		'public' => false,
		'has_archive' => false,
		'capability_type' => 'post'
    );
	register_post_type( 'match-fixture', $args ); //max 20 charachter cannot contain capital letters and spaces


}
add_action( 'init', 'register_themepost', 20 );
*/

// Register Taxonomy
/*
function create_taxonomy() {

	// Portfolyo Kategorisi
	register_taxonomy(
		'player-cat',
		'players',
		array(
			'show_in_nav_menus'	=> false,
			'query_var'			=> is_admin(),
			'public'			=> false,
			'hierarchical'		=> true,
			'labels' => array(
				'name'			=> 'Mevki',
				'singular_name'	=> 'Mevki'
			),
			'show_ui'			=> true,
			'show_admin_column'	=> false,
			'show_in_rest'		=> true,
			'query_var'			=> true,
			// 'rewrite' => array( 'slug' => 'hizmet' ),
		)
	);

}
add_action( 'init', 'create_taxonomy', 20 );
*/





/**
* Pagination
*
* @param int $pages number of pages.
* @param int $range number of links to show of lest and right from current post.
*
* @return html Returns the pagination html block.
*/
function wds_pagination($pages = '', $range = 3) {
	global $paged;
	$showitems = ($range * 2)+1; // links to show
	// init paged
	if(empty($paged))
		$paged = 1;
	// init pages
	if($pages == '') {
		global $wp_query;
		$pages = $wp_query->max_num_pages;
		if(!$pages)
			$pages = 1;
	}
	// if $pages more then one post
	if(1 != $pages) {
		echo '<ul class="pagination d-flex align-items-center justify-content-center">';
		// First link

		if($paged > 2 && $paged > $range+1 && $showitems < $pages)
			echo '<li><a href="' . get_pagenum_link(1) . '">«</a></li>';

		// Previous link
		// if($paged > 1 && $showitems < $pages)
		// 	echo '<li><a href="'.get_pagenum_link($paged - 1).'"><</a></li>';

		// Links of pages
		for ($i=1; $i <= $pages; $i++)
			if (1 != $pages && ( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
			echo ($paged == $i) ? '<li><a href="' . get_pagenum_link($i) . '" class="active">' . $i . '</a></li>' : '<li><a href="' . get_pagenum_link($i) . '">' . $i . '</a></li>';

		// Next link
		// if ($paged < $pages && $showitems < $pages)
		// 	echo '<li><a href="' . get_pagenum_link($paged + 1) . '">></a></li>';

		// Last link
		if ($paged < $pages-1 && $paged+$range-1 < $pages && $showitems < $pages)
			echo '<li><a href="' . get_pagenum_link($pages) . '">»</a></li>';

		echo '</ul>';
	}
}


// Text Permalink
function remove_accent($str) {
  $a = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  $b = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  return str_replace($a, $b, $str);
}

function post_slug($str) {
	return strtolower(preg_replace(array('/[^a-zA-Z0-9 -]/', '/[ -]+/', '/^-|-$/'),
	array('', '-', ''), remove_accent($str)));
}



/**
 * Plugin Name: Hash Upload Filename
 * Plugin URI:  http://stackoverflow.com/questions/3259696
 * Description: Rename uploaded files as the hash of their original.
 * Version:     0.1
 */

/**
 * Filter {@see sanitize_file_name()} and return an MD5 hash.
 *
 * @param  string $filename
 * @return string
 */
function so_3261107_hash_filename( $filename ) {
    $info = pathinfo( $filename );
    $ext  = empty( $info['extension'] ) ? '' : '.' . $info['extension'];
    $name = basename( $filename, $ext );

    // return md5( $name ) . $ext;
    return post_slug( $name ) . $ext;
}

add_filter( 'sanitize_file_name', 'so_3261107_hash_filename', 10 );


// Breadcrumb
function breadcrumb() {
	global $post, $author;

	$thumb = null;
	if ( is_single() ) {

		$page_title = $post->post_title;
		$links = array();
		$args = array('orderby' => 'term_id', 'order' => 'ASC');
		$term_list = wp_get_post_terms( $post->ID, 'category', $args );
		foreach ( $term_list as $term ) {
			$links[] = array( 'link' => get_term_link($term), 'title' => $term->name );
		}
		$links[] = array( 'link' => get_permalink($post->ID), 'title' => $post->post_title );

	} elseif ( is_category() ) {

		// $cat = get_term_by('name', single_cat_title('', false), 'category');
		$cat = get_category( get_query_var( 'cat' ) );
		// print_r($cat);

		$page_title = $cat->name;
		$links = array();

		if ( $cat->parent == 0 ) {
			$links[] = array( 'link' => get_term_link($cat), 'title' => $cat->name );

		} else {
			$p = get_term( $cat->parent, 'category' );
			$links[] = array( 'link' => get_term_link($p), 'title' => $p->name );
			$links[] = array( 'link' => get_term_link($cat), 'title' => $cat->name );

		}

	} elseif ( is_tag() ) {
		$tag = get_term_by('name', single_cat_title('', false), 'post_tag');

		$page_title = $tag->name;
		$links = array();
		$links[] = array( 'link' => get_term_link($tag), 'title' => $tag->name );

	} elseif ( is_search() ) {


		$page_title = sprintf( __( 'Arama Sonuçları: %s', LANG ), get_query_var('s') );
		$links = array();
		$links[] = array( 'link' => 'javascript:;', 'title' => $page_title );

	} elseif ( is_404() ) {

		$page_title = __( '404 Page', LANG );
		$links = array();
		$links[] = array( 'link' => 'javascript:;', 'title' => $page_title );

	} elseif ( is_post_type_archive() ) {
		
		$page_title = post_type_archive_title('', false);
		$links = array();
		$links[] = array( 'link' => 'javascript:;', 'title' => $page_title );

	} elseif ( $post->post_type == 'page' ) {
		
		$page_title = $post->post_title;
		$links = array();
		$links[] = array( 'link' => get_permalink($post->ID), 'title' => $post->post_title );

	} elseif ( is_author() ) {

		$curauth = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));

		$page_title = $curauth->display_name;
		$links = array();
		$links[] = array( 'link' => get_author_posts_url($curauth->ID), 'title' => $page_title );

	}

	$b = '<ul class="breadcrumb d-flex align-items-center">';
		$b .= '<li><a href="' . home_url('/') . '">' . __( 'Pardus Topluluk Portalı', LANG ) . '</a></li>';
			if ( is_home() || is_front_page() ) {
				$b .= '<li><a href="' . home_url('/') . '" class="active">' . __( 'Anasayfa', LANG ) . '</a></li>';
			}
			if ( $links ) {
				foreach ( $links as $key => $link ) {
					$b .= '<li><a href="' . $link['link'] . '" class="' . ( $key == ( count($links) - 1 ) ? 'active': null ) . '">' . $link['title'] . '</a></li>';
				}
			}
	$b .= '</ul>';


	return $b;
}


//estimated reading time
function reading_time() {
	global $post;
	$content = get_post_field( 'post_content', $post->ID );
	$word_count = str_word_count( strip_tags( $content ) );
	$readingtime = ceil($word_count / 200);
	if ($readingtime == 1) {
		$timer = " dakikalık okuma";
	} else {
		$timer = " dakikalık okuma";
	}
	$totalreadingtime = $readingtime . $timer;
	return $totalreadingtime;
}



function add_extra_fields_for_users( $user ) { ?>
	<table class="form-table">
	<tr>
			<th><label for="user_title">Ünvan</label></th>
			<td><input type="text" name="user_title" id="user_title" value="<?php echo esc_attr(get_the_author_meta( 'user_title', $user->ID )); ?>" class="regular-text" /></td>
		</tr>
		<tr>
			<th><label for="show_in_list">Yazarlar Listesinde Görünürlüğü</label></th>
			<td>
				<select name="show_in_list" id="show_in_list">
					<option value="">Seçiniz</option>
					<option value="1" <?php selected( get_the_author_meta( 'show_in_list', $user->ID ), '1' ); ?>>Göster</option>
					<option value="0" <?php selected( get_the_author_meta( 'show_in_list', $user->ID ), '0' ); ?>>Gizle</option>
				</select>
			</td>
		</tr>
	</table>

<?php }
add_action( 'show_user_profile', 'add_extra_fields_for_users' );
add_action( 'edit_user_profile', 'add_extra_fields_for_users' );

function save_extra_fields_for_users( $user_id ) {
	update_user_meta( $user_id, 'user_title', sanitize_text_field( $_POST['user_title'] ) );
	update_user_meta( $user_id, 'show_in_list', sanitize_text_field( $_POST['show_in_list'] ) );
}
add_action( 'personal_options_update', 'save_extra_fields_for_users' );
add_action( 'edit_user_profile_update', 'save_extra_fields_for_users' );

?>