<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
global $pd_option;
$options      = array();


// -----------------------------------------
// Page Settings
// -----------------------------------------
$options[]    = array(
    'id'        => '_match_settings',
    'title'     => 'Maç Detayları',
    'post_type' => array('match-fixture'),
    'context'   => 'normal',
    'priority'  => 'default',
    // 'clonable'     => true,
    'sections'  => array(

        array(
            'name'      => 'section_header_page',
            // 'title'      => 'Başlık/Yazı Ayarları',
            'fields'    => array(

                array(
                    'id'              => 'pd_mac_bilgisi',
                    'type'            => 'group',
                    'title'           => 'Maç Özeti',
                    'desc'            => 'Maç özetini buraya ekleyebilirsiniz.',
                    'button_title'    => 'Yeni Ekle',
                    'accordion_title' => 'dakika takim',
                    'fields'          => array(
                    
                        array(
                            'id'          => 'dakika',
                            'type'        => 'text',
                            'title'       => 'Dakika',
                        ),
                    
                        array(
                            'id'          => 'takim',
                            'type'        => 'select',
                            'title'       => 'Takım',
                            'options'    => array(
                                '' => 'Seçiniz',
                                'ev-sahibi' => 'Ev Sahibi',
                                'deplasman' => 'Deplasman',
                            ),
                        ),
                    
                        array(
                            'id'          => 'pozisyon_bilgisi',
                            'type'        => 'select',
                            'title'       => 'Pozisyon Bilgisi',
                            'options'    => array(
                                '' => 'Seçiniz',
                                'gol'    => 'Gol',
                                'oyuncu-degisikligi'     => 'Oyuncu Değişikliği',
                                'sari-kart'   => 'Sarı Kart',
                                'kirmizi-kart'   => 'Kırmızı Kart',
                                'sari-kirmizi-kart'   => 'Sarıdan Kırmızı Kart',
                                'sakatlik'   => 'Sakatlik',
                            ),
                        ),

                        array(
                            'id'          => 'player',
                            'type'        => 'text',
                            'title'       => 'Futbolcu',
                            'options'       => 'posts',
                            // 'class'      => 'chosen',
                            // query_args is option for all
                            // 'query_args'    => array(
                            //     'sort_order'  => 'ASC',
                            //     'sort_column' => 'post_title',
                            //     'post_type' => 'players',
                            //     'posts_per_page' => -1,
                            // ),
                        ),

                        array(
                            'id'          => 'new_player',
                            'type'        => 'text',
                            'title'       => 'Yeni Giren Futbolcu',
                            'dependency'   => array( 'pozisyon_bilgisi', '==', 'oyuncu-degisikligi' ),
                        ),
                    
                    )
                ),
            ),
        ),

    ),
);


$options[]    = array(
    'id'        => '_player_settings',
    'title'     => 'Oyuncu Detayları',
    'post_type' => array('players'),
    'context'   => 'normal',
    'priority'  => 'default',
    // 'clonable'     => true,
    'sections'  => array(

        array(
            'name'      => 'section_personal',
            'title'      => 'Kişisel Bilgiler',
            'fields'    => array(

                array(
                    'title' => __( 'Transfermarkt Adresi', LANG ),
                    'id'    => 'transfermarkt_url',
                    'desc'    => 'Oyuncunun transfermarkt.com.tr\'de ki profil linkini buraya yazınız.',
                    'type' => 'text',
                ),
        
                array(
                    'title' => __( 'Forma Numarası', LANG ),
                    'id'    => 'forma_numarasi',
                    'type' => 'number',
                ),
        
                array(
                    'title' => __( 'Klübe Katılma Tarihi', LANG ),
                    'id'    => 'klube_katilma_tarihi',
                    'type' => 'text',
                ),
        
                array(
                    'title' => __( 'Doğum Yeri', LANG ),
                    'id'    => 'dogum_yeri',
                    'type' => 'text',
                ),
        
                array(
                    'title' => __( 'Doğum Tarihi', LANG ),
                    'id'    => 'dogum_tarihi',
                    'type' => 'text',
                ),
        
                array(
                    'title' => __( 'Boy / Kilo', LANG ),
                    'id'    => 'boy_kilo',
                    'type' => 'text',
                ),
            ),
        ),


        array(
            'name'      => 'section_statistics',
            'title'      => 'İstatistikler',
            'fields'    => array(

                array(
                    'id'        => 'goller',
                    'type'      => 'fieldset',
                    'title'     => 'Goller',
                    'fields'    => array(
                  
                        array(
                            'id'    => 'bu_sezon',
                            'type'  => 'number',
                            'title' => 'Bu Sezon',
                        ),

                        array(
                            'id'    => 'onceki_sezon',
                            'type'  => 'number',
                            'title' => 'Önceki Sezon',
                        ),

                        array(
                            'id'    => 'tum_zamanlar',
                            'type'  => 'number',
                            'title' => 'Tüm Zamanlar',
                        ),

                    ),
                ),

                array(
                    'id'        => 'asistler',
                    'type'      => 'fieldset',
                    'title'     => 'Asistler',
                    'fields'    => array(
                  
                        array(
                            'id'    => 'bu_sezon',
                            'type'  => 'number',
                            'title' => 'Bu Sezon',
                        ),

                        array(
                            'id'    => 'onceki_sezon',
                            'type'  => 'number',
                            'title' => 'Önceki Sezon',
                        ),

                        array(
                            'id'    => 'tum_zamanlar',
                            'type'  => 'number',
                            'title' => 'Tüm Zamanlar',
                        ),

                    ),
                ),

                array(
                    'id'        => 'oynadigi_maclar',
                    'type'      => 'fieldset',
                    'title'     => 'Oynadığı Maçlar',
                    'fields'    => array(
                  
                        array(
                            'id'    => 'bu_sezon',
                            'type'  => 'number',
                            'title' => 'Bu Sezon',
                        ),

                        array(
                            'id'    => 'onceki_sezon',
                            'type'  => 'number',
                            'title' => 'Önceki Sezon',
                        ),

                        array(
                            'id'    => 'tum_zamanlar',
                            'type'  => 'number',
                            'title' => 'Tüm Zamanlar',
                        ),

                    ),
                ),

                array(
                    'id'        => 'penalti_golleri',
                    'type'      => 'fieldset',
                    'title'     => 'Penaltı Golleri',
                    'fields'    => array(
                  
                        array(
                            'id'    => 'bu_sezon',
                            'type'  => 'number',
                            'title' => 'Bu Sezon',
                        ),

                        array(
                            'id'    => 'onceki_sezon',
                            'type'  => 'number',
                            'title' => 'Önceki Sezon',
                        ),

                        array(
                            'id'    => 'tum_zamanlar',
                            'type'  => 'number',
                            'title' => 'Tüm Zamanlar',
                        ),

                    ),
                ),

                array(
                    'id'        => 'gol_basina_dakikalar',
                    'type'      => 'fieldset',
                    'title'     => 'Gol Başına Dakikalar',
                    'fields'    => array(
                  
                        array(
                            'id'    => 'bu_sezon',
                            'type'  => 'text',
                            'title' => 'Bu Sezon',
                        ),

                        array(
                            'id'    => 'onceki_sezon',
                            'type'  => 'text',
                            'title' => 'Önceki Sezon',
                        ),

                        array(
                            'id'    => 'tum_zamanlar',
                            'type'  => 'text',
                            'title' => 'Tüm Zamanlar',
                        ),

                    ),
                ),

                array(
                    'id'        => 'oynatilan_dakikalar',
                    'type'      => 'fieldset',
                    'title'     => 'Oynatılan Dakikalar',
                    'fields'    => array(
                  
                        array(
                            'id'    => 'bu_sezon',
                            'type'  => 'text',
                            'title' => 'Bu Sezon',
                        ),

                        array(
                            'id'    => 'onceki_sezon',
                            'type'  => 'text',
                            'title' => 'Önceki Sezon',
                        ),

                        array(
                            'id'    => 'tum_zamanlar',
                            'type'  => 'text',
                            'title' => 'Tüm Zamanlar',
                        ),

                    ),
                ),


                array(
                    'id'        => 'fakeid',
                    'type'      => 'heading',
                    'title'     => 'Kaleciye Özel Veriler',
                ),

                array(
                    'id'        => 'karsi_gol_bulunmayan_musabakalar',
                    'type'      => 'fieldset',
                    'title'     => 'Karşı Gol Bulunmayan Müsabakalar',
                    'fields'    => array(
                  
                        array(
                            'id'    => 'bu_sezon',
                            'type'  => 'number',
                            'title' => 'Bu Sezon',
                        ),

                        array(
                            'id'    => 'onceki_sezon',
                            'type'  => 'number',
                            'title' => 'Önceki Sezon',
                        ),

                        array(
                            'id'    => 'tum_zamanlar',
                            'type'  => 'number',
                            'title' => 'Tüm Zamanlar',
                        ),

                    ),
                ),

            ),
        ),

        array(
            'name'      => 'section_thumbnails',
            'title'      => 'Görseller',
            'fields'    => array(

                array(
                    'title' => __( 'Anasayfa Slider (Web)', LANG ),
                    'type' => 'image',
                    'id'   => 'anasayfa_slider_web',
                    'max_file_uploads' => 1,
                ),
                array(
                    'title' => __( 'Anasayfa Slider (Mobil)', LANG ),
                    'type' => 'image',
                    'id'   => 'anasayfa_slider_mobil',
                    'max_file_uploads' => 1,
                ),
        
                array(
                    'title' => __( 'Oyuncu Detay Görseli (Web)', LANG ),
                    'type' => 'image',
                    'id'   => 'oyuncu_detay_gorseli_web',
                    'max_file_uploads' => 1,
                ),
                array(
                    'title' => __( 'Oyuncu Detay Görseli (Mobil)', LANG ),
                    'type' => 'image',
                    'id'   => 'oyuncu_detay_gorseli_mobil',
                    'max_file_uploads' => 1,
                ),

                array(
                    'title' => __( 'Fotoğraf Galerisi', LANG ),
                    'type' => 'gallery',
                    'id'   => 'fotograf_galerisi',
                ),
        
            ),
        ),

    ),
);


$options[]    = array(
    'id'        => '_page_settings',
    'title'     => 'Sayfa Detayları',
    'post_type' => array('page'),
    'context'   => 'normal',
    'priority'  => 'default',
    // 'clonable'     => true,
    'sections'  => array(

        array(
            'name'      => 'section_1',
            'title'      => 'Sayfa Bilgiler',
            'fields'    => array(

                array(
                    'title' => __( 'Sayfa Bannerı', LANG ),
                    'id'    => 'header_bg',
                    'desc'    => 'Yazı içinde sayfanın üst bölümündeki bannerı değiştirmek istiyorsanız buraya yükleyiniz. Tavsiye edilen görsel boyutu 2880x1024px.',
                    'type' => 'image',
                    'max_file_uploads' => 1,

                ),

                array(
                    'title' => __( 'Başlığı Gizle', LANG ),
                    'id'    => 'hide_title',
                    'desc'    => 'Yazı içinde sayfa başlığı gösterilmesini istemiyorsanız bu kutuyu işaretleyin.',
                    'type' => 'checkbox',
                    'label'   => 'Gizle',
                ),


                array(
                    'title' => __( 'Sidebarı Gizle', LANG ),
                    'id'    => 'hide_sidebar',
                    'desc'    => 'Yazı içinde sidebarın gösterilmesini istemiyorsanız bu kutuyu işaretleyin.',
                    'type' => 'checkbox',
                    'label'   => 'Gizle',
                ),

            ),
        ),


        // array(
        //     'name'      => 'section_u_xx',
        //     'title'      => 'Kadın Futbol ve U-XX Bilgileri',
        //     'fields'    => array(

        //         // array(
        //         //     'id'	=> 'fakeid',
        //         //     'type'	=> 'notice',
        //         //     'class'   => 'info',
        //         //     'content'	=> __('Bu ayarlar "<b>Kadın Futbol ve U-XX</b>" sayfa şablonunda aktiftir.', LANG),
        //         // ),

        //         array(
        //             'id'	=> 'uxx_players',
        //             'type'	=> 'group',
        //             'title'	=> __('Oyuncular', LANG),
        //             'button_title'		=> __('Oyuncu Ekle', LANG),
        //             'accordion_title' 	=> __('Yeni Oyuncu Ekle', LANG),
        //             'fields' => array(
        
        //                 array(
        //                     'id'	=> 'name',
        //                     'type'	=> 'text',
        //                     'title'	=> __('Adı Soyadı', LANG),
        //                 ),

        //                 array(
        //                     'id'	=> 'number',
        //                     'type'	=> 'number',
        //                     'title'	=> __('Forma Numarası', LANG),
        //                 ),

        //                 array(
        //                     'id'	=> 'position',
        //                     'type'	=> 'text',
        //                     'title'	=> __('Mevki', LANG),
        //                 ),

        //             ),
        //         ),

        //         array(
        //             'id'	=> 'technical_person',
        //             'type'	=> 'group',
        //             'title'	=> __('İdari ve Teknik Personel', LANG),
        //             'button_title'		=> __('Personel Ekle', LANG),
        //             'accordion_title' 	=> __('Yeni Personel Ekle', LANG),
        //             'fields' => array(
        
        //                 array(
        //                     'id'	=> 'name',
        //                     'type'	=> 'text',
        //                     'title'	=> __('Adı Soyadı', LANG),
        //                 ),

        //                 array(
        //                     'id'	=> 'position',
        //                     'type'	=> 'text',
        //                     'title'	=> __('Rütbe', LANG),
        //                 ),

        //             ),
        //         ),

        //     ),
        // ),

        
        array(
            'name'      => 'section_u_katki',
            'title'      => 'Ayrıntılı Bilgi ve Başvuru Buton Linkleri',
            'fields'    => array(

                array(
                    'id'	=> 'page_ayrintili_bilgi',
                    'type'	=> 'text',
			        'title'	=> __('Ayrıntılı Bilgi', LANG),
                ),

                array(
                    'id'	=> 'page_basvuru',
                    'type'	=> 'text',
			        'title'	=> __('Başvuru', LANG),
                ),

            ),
        ),



    ),
);


CSFramework_Metabox::instance( $options );
