<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================

$settings           = array(
	'menu_title'		=> 'Tema Ayarları',
	'menu_type'			=> 'menu', // menu, submenu, options, theme, etc.
	'menu_slug'			=> PEND_PREFIX . '-framework',
	'ajax_save'			=> true,
	'framework_title'	=> 'Tema Ayarları <small>by <a href="https://pendigital.com/?utm_source=customer&utm_medium=admin-panel&utm_campaign=' . $_SERVER['SERVER_NAME'] . '" rel="nofollow" target="_blank" style="color: #555; text-decoration: none;">PenDigital</a></small>',
	'menu_capability'	=> 'edit_theme_options'
);
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options	= array();

$options[]	= array(
	'name'	=> 'genel-options',
	'title'	=> __( 'Genel Ayarları', LANG ),
	'icon'	=> 'fa fa-fog',

	// begin: fields
	'fields'	=> array(


	), // end: fields
);


$options[]	= array(
	'name'	=> 'home-options',
	'title'	=> __( 'Anasayfa Ayarları', LANG ),
	'icon'	=> 'fa fa-home',

	// begin: fields
	'fields'	=> array(

		// Slider Options
		array(
			'id'	=> 'fakeid',
			'type'	=> 'heading',
			'title'	=> __( 'Slider Ayarları', LANG ), 
		),

		array(
			'id'	=> 'home_slider',
			'type'	=> 'group',
			'title'	=> __('Sliderlar', LANG),
			'button_title'		=> __('Slider Ekle', LANG),
			'accordion_title' 	=> __('Yeni Slider Ekle', LANG),
			'fields' => array(

				array(
					'id'	=> 'title',
					'type'	=> 'text',
					'title'	=> __('Başlık', LANG),
				),

				array(
					'id'	=> 'sub_text',
					'type'	=> 'text',
					'title'	=> __('Sağ taraf yönlendirici text', LANG),
					'desc'	=> __('Ör: Makaleyi oku', LANG),
				),

				array(
					'id'	=> 'thumbnail',
					'type'	=> 'image',
					'title'	=> __('Görsel', LANG),
					'desc' => __('Görseller 1263x475 boyutunda olmalı', LANG),
				),

				array(
					'id'	=> 'thumbnail_mobile',
					'type'	=> 'image',
					'title'	=> __('Mobil Görsel', LANG),
					'desc' => __('Görseller 414×386 boyutunda olmalı', LANG),
				),

				array(
					'id'	=> 'url',
					'type'	=> 'text',
					'title'	=> __('Link', LANG),
				),


			),
		),

		// Kategor Options
		array(
			'id'	=> 'fakeid',
			'type'	=> 'heading',
			'title'	=> __( 'Kategori Ayarları', LANG ), 
		),

		array(
			'id'	=> 'home_categories',
			'type'	=> 'group',
			'title'	=> __('Kategoriler', LANG),
			'button_title'		=> __('Kategori Ekle', LANG),
			'accordion_title' 	=> __('Yeni Kategori Ekle', LANG),
			'fields' => array(

				array(
					'id'	=> 'title',
					'type'	=> 'text',
					'title'	=> __('Başlık', LANG),
				),

				array(
					'id'             => 'cat_id',
					'type'           => 'select',
					'title'          => __('Kategori', LANG),
					'options'        => 'categories',
					'query_args'     => array(
						'orderby'      => 'name',
						'order'        => 'ASC',
					),
					'default_option' => __('Kategori seçin', LANG),
					'class'         => 'chosen',
				),

				array(
					'id'	=> 'count',
					'type'	=> 'number',
					'title'	=> __('İçerik sayısı', LANG),
					'default'	=> 10,
				),


			),
		),


	), // end: fields
);



$options[]	= array(
	'name'	=> 'page-options',
	'title'	=> 'Sayfalar',
	'icon'	=> 'fa fa-file',

	// begin: fields
	'fields'	=> array(

		array(
			'id'	=> 'link_pardus_download',
			'type'	=> 'text',
			'title'	=> __('Pardusu İndirin Sayfasının Adresi', LANG),
		),

		array(
			'id'	=> 'link_forum',
			'type'	=> 'text',
			'title'	=> __('Forum Adresi', LANG),
		),

		array(
			'id'	=> 'link_login',
			'type'	=> 'text',
			'title'	=> __('Giriş Yap Sayfasının Adresi', LANG),
		),

		array(
			'id'	=> 'link_register',
			'type'	=> 'text',
			'title'	=> __('Kayıt Ol Sayfasının Adresi', LANG),
		),

		array(
			'id'	=> 'page_katki_sagla',
			'type'	=> 'select',
			'title'	=> 'Katkı Sağla',
			'desc'	=> 'Katkı Sağla sayfasını seçiniz',
			'options'	=> 'pages',
			// query_args is option for all
			'query_args'	=> array(
				'sort_order'	=> 'ASC',
				'sort_column'	=> 'post_title',
				'posts_per_page'	=> -1,
			),
		),

		// array(
		// 	'id'	=> 'page_oneride_bulun',
		// 	'type'	=> 'select',
		// 	'title'	=> 'Öneride Bulun',
		// 	'desc'	=> 'Öneride Bulun sayfasını seçiniz',
		// 	'options'	=> 'pages',
		// 	// query_args is option for all
		// 	'query_args'	=> array(
		// 		'sort_order'	=> 'ASC',
		// 		'sort_column'	=> 'post_title',
		// 		'posts_per_page'	=> -1,
		// 	),
		// ),

		// array(
		// 	'id'	=> 'page_ayrintili_bilgi',
		// 	'type'	=> 'select',
		// 	'title'	=> 'Ayrıntılı Bilgi',
		// 	'desc'	=> 'Ayrıntılı Bilgi sayfasını seçiniz',
		// 	'options'	=> 'pages',
		// 	// query_args is option for all
		// 	'query_args'	=> array(
		// 		'sort_order'	=> 'ASC',
		// 		'sort_column'	=> 'post_title',
		// 		'posts_per_page'	=> -1,
		// 	),
		// ),

		// array(
		// 	'id'	=> 'page_basvuru',
		// 	'type'	=> 'select',
		// 	'title'	=> 'Başvuru',
		// 	'desc'	=> 'Başvuru sayfasını seçiniz',
		// 	'options'	=> 'pages',
		// 	// query_args is option for all
		// 	'query_args'	=> array(
		// 		'sort_order'	=> 'ASC',
		// 		'sort_column'	=> 'post_title',
		// 		'posts_per_page'	=> -1,
		// 	),
		// ),


	), // end: fields
);


$options[]	= array(
	'name'	=> 'custom-code-options',
	'title'	=> 'Özel CSS / JS Kodları',
	'icon'	=> 'fa fa-code',

	// begin: fields
	'fields'	  => array(

		array(
			'id'	=> 'custom_css',
			'type'	=> 'aceeditor',
			'title'	=> 'Özel CSS Kodu',
			'attributes'		=> array(
				'data-theme'	=> 'monokai',
				'data-mode'		=> 'css',
			),
		),

		array(
			'id'	=> 'custom_js',
			'type'	=> 'aceeditor',
			'title'	=> 'Özel Javascript Kodu',
			'attributes'		=> array(
				'data-theme'	=> 'monokai',
				'data-mode'		=> 'javascript',
			),
		),

		array(
			'id'	=> 'footer_scripts',
			'type'	=> 'aceeditor',
			'title'	=> 'Özel Footer Scriptleri',
			'attributes'		=> array(
				'data-theme'	=> 'monokai',
				'data-mode'		=> 'html',
			),
		),

	), // end: fields
);



$options[]	= array(
	'name'	=> 'social-options',
	'title'	=> 'Sosyal Medya Hesapları',
	'icon'	=> 'fa fa-google-plus',

	// begin: fields
	'fields'	=> array(
		array(
			'id'	=> 'social-media',
			'type'	=> 'group',
			'title'	=> __('Sosyal Medya Hesapları', LANG),
			'button_title'		=> __('Yeni Ekle', LANG),
			'accordion_title' 	=> __('Yeni Ekle', LANG),
			'fields' => array(	
				array(
					'id'         => 'sm-image',
					'type'       => 'select',
					'title'      => 'Logo',
					'options'    => array(
						'artboard-106.svg' => 'Artboard',
						'asana-sqaure.svg' => 'Asana',
						'behance-square.svg' => 'Behance',
						'blogger.svg' => 'Blogger',
						'dribbble.svg' => 'Dribbble',
						'dropbox.svg' => 'Dropbox',
						'facebook.svg' => 'Facebook',
						'facebook-messanger-circle.svg' => 'Facebook Messanger',
						'figma.svg' => 'Figma',
						'flickr.svg' => 'Flickr',
						'framer-square.svg' => 'Framer',
						'github.svg' => 'Github',
						'gitlab-square.svg' => 'Gitlab',
						'google.svg' => 'Google',
						'google-drive.svg' => 'Google Drive',
						'gumroad-square.svg' => 'Google',
						'instagram.svg' => 'Instagram',
						'intercom.svg' => 'Intercom',
						'linkedin.svg' => 'Linkedin',
						'map1.svg' => 'Map',
						'medium.svg' => 'Medium',
						'patreon.svg' => 'Patreon',
						'picasa.svg' => 'Picasa',
						'pinterest.svg' => 'Pinterest',
						'producthunt.svg' => 'Producthunt',
						'shazam.svg' => 'Shazam',
						'sketch.svg' => 'Sketch',
						'snapchat.svg' => 'Snapchat',
						'spectrum.svg' => 'Spectrum',
						'spotify.svg' => 'Spotify',
						'telegram.svg' => 'Telegram',
						'trello.svg' => 'Trello',
						'twitter.svg' => 'Twitter',
						'vkontakte.svg' => 'Vkontakte',
						'youtube.svg' => 'Youtube',
					),

					'class'      => 'chosen',

				),
				array(
					'id'	=> 'sm-link',
					'type'	=> 'text',
					'title'	=> __('Link', LANG),
				),
			),
		),
	), // end: fields
);



$options[]	= array(
	'name'	=> 'api-options',
	'title'	=> 'API Ayarları',
	'icon'	=> 'fa fa-code',

	// begin: fields
	'fields'	=> array(

		array(
			'id'	=> 'forum_api',
			'type'	=> 'text',
			'title'	=> __('Forum API Kodu', LANG),
		),

	), // end: fields
);

$options[]	= array(
	'name'		=> 'backup_section',
	'title'		=> 'Yedekleme',
	'icon'		=> 'fa fa-shield',
	'fields'	=> array(

		array(
			'type'		=> 'notice',
			'class'		=> 'warning',
			'content'	=> 'Export / Import Backups',
		),

		array(
			'type'	=> 'backup',
		),

	)
);

CSFramework::instance( $settings, $options );
