<?php
    global $pd_option;
    get_header();


    $category = get_category( get_query_var( 'cat' ) );
    // $cat_id = $category->cat_ID;

    // print_r($category);

    $cat_parent = 0;

    if ( $category->parent == 0 ) {
        $cat_parent = $category->term_id;

    } else {
        $cat_parent = $category->category_parent;

    }



    // Pagination Text
    $total_post = $category->count;
    $posts_per_page = get_option('posts_per_page');
    $count_between = '0 - ' . ( $total_post > $posts_per_page ? $posts_per_page: $total_post );

    if ( $paged > 0 ) {
        $first = ( ( $paged - 1 ) * $posts_per_page ) + 1;
        $last = $paged * $posts_per_page;

        if ( $last > $total_post ) {
            $last = $total_post;
        }

        $count_between = $first . ' - ' . $last;
        
    }


?>

    <!-- Middle Content -->
    <div class="m-content">

        <!-- Breadcrumb -->
        <?php echo breadcrumb(); ?>


        <!-- Tab System -->
        <div class="tab-system">
            <?php 
                $categories = get_categories( array(
                    'orderby' => 'name',
                    'parent'  => $cat_parent,
                    'hide_empty' => false
                ) );
            ?>
            <!-- Tab Nav -->
            <?php 
                if ( $categories ) {  
                    echo '<ul class="tab-nav d-flex">';
                    foreach ( $categories as $cat )  {
                        $class = '';
                        if($category->term_id == $cat->term_id){
                            $class = 'active';
                        }
                    ?>
                        <li><a href="<?php echo get_category_link($cat->term_id); ?>" class="d-flex align-items-center justify-content-center <?php echo $class; ?>"><?php echo $cat->name ?></a></li>
                    <?php  }
                    echo '</ul>';
                } 
            ?>
            

            <!-- Tab Content -->
            <div class="tab-content">

                <!-- Tab: Blog -->
                <div class="tab tab-blog in">

                    <!-- Tab Title Area -->
                    <div class="tab-title-area d-flex flex-sm-row flex-column align-items-center justify-content-between">
                        <!-- Title -->
                        <div class="t-title"><?php single_cat_title(); ?></div>

                        <!-- Small Text -->
                        <div class="t-small-text"><?php echo $category->count; ?> adet blog yazısından <b><?php echo $count_between; ?> aralığını</b> görüntülüyorsunuz</div>
                    </div>

                    <!-- Blog Card List -->
                    <div class="blog-card-list">

                        <?php

                            if ( have_posts() ) :
                                while ( have_posts() ) :
                                    the_post();

                                    get_template_part('modules/blog', 'card');

                                endwhile;
                            endif;

                        ?>

                    </div>

                    <!-- Pagination -->
                    <?php wds_pagination(); ?>

                </div>
            </div>

        </div>


    </div>

<?php get_footer(); ?>