<?php
    global $pd_option;
    get_header();


    $curauth = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));


    // print_r($curauth);

    // Pagination Text
    $total_post = count_user_posts($curauth->ID);
    $posts_per_page = get_option('posts_per_page');
    $count_between = '0 - ' . ( $total_post > $posts_per_page ? $posts_per_page: $total_post );

    if ( $paged > 0 ) {
        $first = ( ( $paged - 1 ) * $posts_per_page ) + 1;
        $last = $paged * $posts_per_page;

        if ( $last > $total_post ) {
            $last = $total_post;
        }

        $count_between = $first . ' - ' . $last;
        
    }


?>

    <!-- Middle Content -->
    <div class="m-content">

        <!-- Breadcrumb -->
        <?php echo breadcrumb(); ?>


        <!-- Tab System -->
        <div class="tab-system">

            <!-- Tab Content -->
            <div class="tab-content">

                <!-- Tab: Blog -->
                <div class="tab tab-blog in">

                    <!-- Tab Title Area -->
                    <div class="tab-title-area d-flex flex-sm-row flex-column align-items-center justify-content-between">
                        <!-- Title -->
                        <div class="t-title">Yazar: <?php echo $curauth->display_name; ?></div>

                        <!-- Small Text -->
                        <div class="t-small-text"><?php echo $total_post; ?> adet blog yazısından <b><?php echo $count_between; ?> aralığını</b> görüntülüyorsunuz</div>
                    </div>

                    <!-- Blog Card List -->
                    <div class="blog-card-list">

                        <?php

                            if ( have_posts() ) :
                                while ( have_posts() ) :
                                    the_post();

                                    get_template_part('modules/blog', 'card');

                                endwhile;
                            endif;

                        ?>

                    </div>

                    <!-- Pagination -->
                    <?php wds_pagination(); ?>

                </div>
            </div>

        </div>


    </div>

<?php get_footer(); ?>