// Add class to body if browser supports to "webp"
if (canUseWebP() == true) {
    var body = document.body;
    body.classList.add('webp-support');

} else if (canUseWebP() != true) {
    var body = document.body;
    body.classList.add('no-webp-support');

}

$(document).ready(function() {
    $('#home-slider .owl-carousel').owlCarousel({
        items: 1,
        loop: true,
        dots: false,
        nav: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
    });

    // User Devices
    $.isMobile = false;
    $('html').addClass('device-desktop');
    if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) ||
        /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0, 4))) {
        $.isMobile = true;

        $('html').removeClass('device-desktop').addClass('device-mobile');
    }
    // console.info('$.isMobile:', $.isMobile);


    // if ( $(window).width() > 768 ) {
    //     wow = new WOW().init();
    // }

    // if ($('.marquee').length > 0) {
    //     $('.marquee').marquee({
    //         pauseOnHover: true,
    //         duration: 25000,
    //         gap: 50,
    //         delayBeforeStart: 0,
    //         direction: 'left',
    //         duplicated: true
    //     });
    // }

    // Get Forum Data: En Aktif Konular
    getForumData({ limit: 5, id: 18, div_id: '#pardus-aktif-konular' });

    // Get Forum Data: En Aktif Konular
    getForumData({ limit: 5, id: 19, div_id: '#pardus-yeni-konular' });

    $('#side-menu ul.menu li.menu-item-has-children > a').click(function(e) {
        e.preventDefault();
        $(this).parent('li').toggleClass('opened');
        // console.info($(this));
    });
    /*
     * Replace all SVG images with inline SVG
     */
    $('img.svg').each(function() {
        var $img = $(this);
        var imgID = $img.attr('id');
        var imgClass = $img.attr('class');
        var imgURL = $img.attr('src');

        $.get(imgURL, function(data) {
            // Get the SVG tag, ignore the rest
            var $svg = $(data).find('svg');

            // Add replaced image's ID to the new SVG
            if (typeof imgID !== 'undefined') {
                $svg = $svg.attr('id', imgID);
            }
            // Add replaced image's classes to the new SVG
            if (typeof imgClass !== 'undefined') {
                $svg = $svg.attr('class', imgClass + ' replaced-svg');
            }

            // Remove any invalid XML tags as per http://validator.w3.org
            $svg = $svg.removeAttr('xmlns:a');

            // Replace image with new SVG
            $img.replaceWith($svg);

        }, 'xml');

    });
});

// Get Forum Data
function getForumData({ limit, id, div_id }) {
    $.ajax({
        type: 'POST',
        url: `${pd.ajax_url}?action=pdGetAjax&get_forum_data=true`,
        data: { limit, id },
        dataType: 'json', 
    }).done(function(j) {

        $(div_id).html('');

        if (j.result == true) {
            if (j.dataCount > 0) {

                if ( j.data.topic && j.data.topic.length > 0 ) {

                    $.each(j.data.topic, function(i, val) {
                        var html = '' +
                            '<div class="blog-card card-' + val['id'] + '">' +
                                '<a href="' + pd.forum_url + '/t/' + val['slug'] + '/' + val['id'] + '" target="_blank" class="row align-items-center">' +
                                    '<span class="col d-flex flex-column">' +
                                        '<span class="title">' + val['title'] + '</span>' +
                                    '</span>' +
                                '</a>' +
                            '</div>';
                        $(div_id).append(html);
                    });

                } else if ( j.data.post && j.data.post.length > 0 ) {

                    $.each(j.data.post, function(i, val) {
                        var html = '' +
                            '<div class="blog-card card-' + val['id'] + '">' +
                                '<a href="' + pd.forum_url + '/t/konu/' + val['topic_id'] + '" target="_blank" class="row align-items-center">' +
                                    // '<span class="col col-img">' +
                                    //     '<img src="' + pd.forum_url + '' + val['avatar_template'].replace('{size}', '70') + '" class="img-responsive border-radius" />' +
                                    // '</span>' +
                                    '<span class="col d-flex flex-column">' +
                                        '<span class="title"><b>' + val['username'] + ':</b> ' + val['excerpt'].replace(/(<([^>]+)>)/ig,"") + '</span>' +
                                    '</span>' +
                                '</a>' +
                            '</div>';
                        $(div_id).append(html);
                    });

                }
            }
        } else {
            $(div_id).html(`<div class="col-12">${j.message}</div>`);
            $(div_id).hide();
        }


    }).fail(function(jqXHR) {
        //When the request failed, execute the passed in function
        // alert(jqXHR.responseJSON.message);

        // $('.list-count').text(`0 adet ev ilanı bulundu`);
        // $(div_id).html(jqXHR.responseJSON.message);
        $(div_id).text(jqXHR.responseJSON.message);
        $(div_id).hide();

    });
}


// Open: Mobile Menu
function openMobileMenu() {
    $('a.mobile-hamburger-menu').attr('onclick', 'closeMobileMenu()');
    $('.hamburger-menu').addClass('animate');
    $('body').addClass('modal-opened');
    $('#left-side').addClass('mobile-menu-opened');
    $('#middle-side .backdrop').addClass('d-block');
    // $('#left-menu').addClass('in');
    // $('#side-menu').fadeIn(400, function() {
    // 	$(this).css({
    // 		display: 'flex'
    // 	});
    // 	$('#side-menu .content').addClass('in');
    // });
}

// Close: Mobile Menu
function closeMobileMenu() {
    $('a.mobile-hamburger-menu').attr('onclick', 'openMobileMenu()');
    $('.hamburger-menu').removeClass('animate');
    $('body').removeClass('modal-opened');
    $('#middle-side .backdrop').removeClass('d-block');
    $('#left-side').removeClass('mobile-menu-opened');


    // $('#side-menu').removeClass('in');
    // $('#side-menu .content').removeClass('in');
    // $('#side-menu').fadeOut();
}


/**
 * Check Can I Use WebP or not
 */
function canUseWebP() {
    var elem = document.createElement('canvas');

    if (!!(elem.getContext && elem.getContext('2d'))) {
        // was able or not to get WebP representation
        return elem.toDataURL('image/webp').indexOf('data:image/webp') == 0;
    }

    // very old browser like IE 8, canvas not supported
    return false;
}





// Tab System
function tabNav(target) {

    $ths = $(this);

    // Tab Nav
    $ths.parents('ul.tab-nav').find('a').removeClass('active');
    $ths.addClass('active');

    // Tab Content
    $ths.parents('.tab-system').find(`.tab-${target}`).addClass('in').siblings('.tab').removeClass('in');

}